/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class VWAdminCompleteWorkDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private VWAdminResultPane m_resultsPane;
    private VWAdminResultTableModelBase m_resultsTableModel;
    private VWSession m_session = null;
    private Frame m_parentFrame = null;
    private Vector m_wobsList = new Vector();
    private Vector m_vErrors = new Vector();
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private VWTable m_table = null;
    private MyTableModel m_tableModel = null;
    private JScrollPane m_scrollPane = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;
    private JLabel m_responseLabel = null;
    private JComboBox m_responseCombo = null;
    private DefaultComboBoxModel m_responseModel = null;
    private String[] m_responses = null;
    private String m_selecteAResponse = VWResource.s_selectAResponse;
    private String m_variousResponses = VWResource.s_variousResponses;
    private String m_nullResponseString = null;
    private boolean m_bMissingResponse = false;

    public VWAdminCompleteWorkDialog(Vector selectedWork, VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_session = resultsPane.getSession();
        this.m_wobsList = selectedWork;
        this.m_resultsPane = resultsPane;
        this.m_resultsTableModel = this.m_resultsPane.getTableModel();
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("665,495");
        if (dim == null) {
            dim = new Dimension(600, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_completeTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.disableControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.doComplete();
            this.doCleanup();
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (object == this.m_applyButton) {
            this.doComplete();
            this.refreshPanel();
        } else if (object == this.m_cancelButton) {
            this.doCleanup();
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah031.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        this.doCleanup();
        this.m_bCanceled = true;
        super.windowClosing(event);
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            JPanel participantsAndResponsesPanel = new JPanel();
            this.setupParticipantsAndResponsesPanel(participantsAndResponsesPanel);
            JPanel commentsPanel = new JPanel();
            this.setupCommentsPanel(commentsPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)participantsAndResponsesPanel, c);
            c.gridx = 0;
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.4;
            mainPanel.add((Component)commentsPanel, c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel setupParticipantsAndResponsesPanel(JPanel panel) {
        try {
            this.m_tableModel = new MyTableModel(this.m_wobsList);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.m_table.setShowGrid(false);
            VWAccessibilityHelper.setAccessibility(this.m_table, panel, VWResource.s_recipientsTable, VWResource.s_recipientsTable);
            this.addListenerForRowSelectionChanged();
            this.m_table.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWAdminCompleteWorkDialog.this.m_table == null || VWAdminCompleteWorkDialog.this.m_table.getModel() == null || VWAdminCompleteWorkDialog.this.m_table.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
            this.m_table.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_scrollPane = new JScrollPane(this.m_table);
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.gridwidth = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel selectedWorkLabel = new JLabel(VWResource.s_selectedWork);
            VWAccessibilityHelper.setAccessibility(selectedWorkLabel, this, VWResource.s_selectedWork, VWResource.s_selectedWork);
            panel.add((Component)selectedWorkLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)this.m_scrollPane, c);
            this.initResponses();
            this.m_responseLabel = new JLabel(VWResource.s_label.toString(VWResource.s_response));
            VWAccessibilityHelper.setAccessibility(this.m_responseLabel, this, VWResource.s_response, VWResource.s_response);
            this.m_responseCombo = new JComboBox(this.m_responseModel);
            VWAccessibilityHelper.setAccessibility(this.m_responseCombo, this, VWResource.s_response, VWResource.s_response);
            VWAccessibilityHelper.setLabelFor(this.m_responseLabel, this.m_responseCombo);
            this.m_responseCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    VWAdminCompleteWorkDialog.this.setButtonState();
                }
            });
            this.m_responseCombo.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                    Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                    ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
                    this.setComponentOrientation(o);
                    ((JLabel)component).setText("");
                    ((JLabel)component).setIcon(null);
                    if (value != null) {
                        if (value instanceof String) {
                            ((JLabel)component).setText((String)value);
                        }
                    } else {
                        ((JLabel)component).setText(VWAdminCompleteWorkDialog.this.m_nullResponseString);
                    }
                    return component;
                }
            });
            c.insets = new Insets(5, 2, 5, 30);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            panel.add((Component)this.m_responseLabel, c);
            c.gridx = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            panel.add((Component)this.m_responseCombo, c);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void setupCommentsPanel(JPanel panel) {
        JLabel commentsLabel = new JLabel(VWResource.s_currentComments);
        VWAccessibilityHelper.setAccessibility(commentsLabel, this, VWResource.s_currentComments, VWResource.s_currentComments);
        JLabel newCommentsLabel = new JLabel(VWResource.s_enterComments);
        VWAccessibilityHelper.setAccessibility(newCommentsLabel, this, VWResource.s_enterComments, VWResource.s_enterComments);
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setText("");
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_commentsUI.setRows(4);
        this.m_commentsUI.setEditable(false);
        VWAccessibilityHelper.setAccessibility(this.m_commentsUI, this, VWResource.s_currentComments, VWResource.s_currentComments);
        VWAccessibilityHelper.setLabelFor(commentsLabel, this.m_commentsUI);
        this.m_newCommentsUI = new JTextArea();
        this.m_newCommentsUI.setText("");
        this.m_newCommentsUI.setLineWrap(true);
        this.m_newCommentsUI.setWrapStyleWord(false);
        this.m_newCommentsUI.setRows(4);
        VWAccessibilityHelper.setAccessibility(this.m_newCommentsUI, this, VWResource.s_enterComments, VWResource.s_enterComments);
        VWAccessibilityHelper.setLabelFor(newCommentsLabel, this.m_newCommentsUI);
        ButtonGroup grp = new ButtonGroup();
        this.m_appendRadio = new JRadioButton(VWResource.s_append, true);
        this.m_appendRadio.addActionListener(this);
        this.m_appendRadio.addKeyListener(VWKeyAdapter.s_keyAdapter);
        VWAccessibilityHelper.setMemberOf(this.m_appendRadio, grp);
        VWAccessibilityHelper.setAccessibility(this.m_appendRadio, panel, VWResource.s_append, VWResource.s_append);
        this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
        this.m_replaceRadio.addActionListener(this);
        this.m_replaceRadio.addKeyListener(VWKeyAdapter.s_keyAdapter);
        VWAccessibilityHelper.setMemberOf(this.m_replaceRadio, grp);
        VWAccessibilityHelper.setAccessibility(this.m_replaceRadio, panel, VWResource.s_replace, VWResource.s_replace);
        grp.add(this.m_appendRadio);
        grp.add(this.m_replaceRadio);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_comments));
        VWAccessibilityHelper.setAccessibility(panel, this, VWResource.s_comments, VWResource.s_comments);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.insets = new Insets(0, 2, 0, 30);
        panel.add((Component)this.m_appendRadio, c);
        c.gridx = 1;
        c.gridwidth = 0;
        panel.add((Component)this.m_replaceRadio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 0;
        panel.add((Component)commentsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_commentsUI), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)newCommentsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_applyButton = new JButton(VWResource.s_apply);
            this.m_applyButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_applyButton, this, VWResource.s_apply, VWResource.s_apply);
            this.m_applyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_applyButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void disableControls() {
        this.m_applyButton.setEnabled(false);
        this.m_okButton.setEnabled(false);
        this.m_responseCombo.setEnabled(false);
        this.m_newCommentsUI.setEnabled(false);
        this.m_newCommentsUI.setText("");
    }

    private void resetControls() {
        this.m_table.clearSelection();
        this.refreshCurrentCommentsPanel();
        this.refreshResponses();
        this.setButtonState();
    }

    private void updateControls() {
        this.refreshCurrentCommentsPanel();
        this.refreshResponses();
        this.setButtonState();
    }

    private void setButtonState() {
        boolean bEnable = false;
        if (this.m_table.getSelectedRowCount() > 0) {
            bEnable = true;
        }
        if (bEnable && this.m_responses != null && this.m_responses.length > 0) {
            bEnable = !this.m_bMissingResponse || this.m_responseCombo.getSelectedIndex() != -1;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private void refreshCurrentCommentsPanel() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            this.m_newCommentsUI.setEnabled(false);
            if (selectedRows.length <= 0) {
                this.m_commentsUI.setText("");
            } else {
                this.m_newCommentsUI.setEnabled(true);
                if (this.isUniqueComments()) {
                    DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[0]);
                    this.m_commentsUI.setText(data.getCurrentComments());
                } else {
                    this.m_commentsUI.setText(VWResource.s_variousValues);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void refreshResponses() {
        boolean bVariousResponse = false;
        int selectedRespIndex = -1;
        int[] selectedRows = this.m_table.getSelectedRows();
        this.m_responseCombo.setEnabled(false);
        if (selectedRows.length <= 0) {
            this.m_nullResponseString = "";
            return;
        }
        DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[0]);
        this.m_responses = data.getResponses();
        this.m_bMissingResponse = false;
        if (this.m_responses != null && this.m_responses.length > 0) {
            this.m_responseCombo.setEnabled(true);
            if (this.m_responseModel == null) {
                this.m_responseModel = new DefaultComboBoxModel();
            } else {
                this.m_responseModel.removeAllElements();
            }
            for (int i = 0; i < this.m_responses.length; ++i) {
                this.m_responseModel.addElement(this.m_responses[i]);
            }
        } else {
            return;
        }
        if (this.isUniqueSelectedResponse()) {
            String selectedResponse = data.getSelectedResponse();
            if (selectedResponse != null) {
                for (int i = 0; i < this.m_responses.length; ++i) {
                    if (this.m_responses[i] == null || VWStringUtils.compare(selectedResponse, this.m_responses[i]) != 0) continue;
                    selectedRespIndex = i;
                }
            } else {
                selectedRespIndex = -1;
                this.m_nullResponseString = this.m_selecteAResponse;
            }
        } else {
            selectedRespIndex = -1;
            this.m_nullResponseString = this.m_variousResponses;
        }
        this.m_responseCombo.setSelectedIndex(selectedRespIndex);
        this.m_responseCombo.updateUI();
    }

    private void addListenerForRowSelectionChanged() {
        ListSelectionModel rowSM = this.m_table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    VWAdminCompleteWorkDialog.this.disableControls();
                } else if (!e.getValueIsAdjusting()) {
                    VWAdminCompleteWorkDialog.this.updateControls();
                }
            }
        });
    }

    private boolean isUniqueComments() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                String comments = data.getCurrentComments();
                for (int j = 0; j < selectedRows.length; ++j) {
                    DataObject anotherData;
                    String anotherComment;
                    if (i == j || VWStringUtils.compare(comments, anotherComment = (anotherData = (DataObject)this.m_tableModel.getObjectAt(selectedRows[j])).getCurrentComments()) == 0) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private boolean isUniqueSelectedResponse() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                String response = data.getSelectedResponse();
                if (response == null) {
                    this.m_bMissingResponse = true;
                }
                for (int j = 0; j < selectedRows.length; ++j) {
                    if (i == j) continue;
                    DataObject anotherData = (DataObject)this.m_tableModel.getObjectAt(selectedRows[j]);
                    String anotherResponse = anotherData.getSelectedResponse();
                    if (response == null) {
                        this.m_bMissingResponse = true;
                        if (anotherResponse == null) continue;
                        return false;
                    }
                    if (anotherResponse == null) {
                        this.m_bMissingResponse = true;
                        continue;
                    }
                    if (VWStringUtils.compare(response, anotherResponse) == 0) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private void doComplete() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            String newComments = this.m_newCommentsUI.getText();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                VWWorkObject wob = data.getWob();
                if (wob == null) continue;
                VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                if (wob.getIsTracker() && (wob.getParticipantName() == null || VWStringUtils.compare(wob.getParticipantName(), "(NONE)") == 0) && VWStringUtils.compare(wob.getLastErrorNumber(), "0") != 0) {
                    String rosterName = wob.getRosterName();
                    String wobNum = wob.getWorkObjectNumber();
                    wob.doTerminate();
                    VWWorkObject vwWorkObject = null;
                    vwWorkObject = this.fetchSpecificWorkObject(this.m_resultsPane.getSession(), rosterName, wobNum);
                    if (vwWorkObject != null) {
                        vwWorkObject.doRefresh(false, false);
                        woData.updateLockedInfo();
                        if (this.doLockSpecificWorkObject(vwWorkObject)) {
                            vwWorkObject.doTerminate();
                        }
                    }
                } else {
                    String comments = data.getCurrentComments();
                    if (this.m_appendRadio.isSelected()) {
                        if (comments == null) {
                            comments = "";
                        }
                        if (newComments != null && newComments.length() > 0) {
                            if (comments.length() > 0) {
                                comments = comments + "\n";
                            }
                            comments = comments + newComments;
                        }
                    } else {
                        comments = newComments != null ? newComments : null;
                    }
                    wob.setFieldValue("F_Comment", comments, true);
                    if (this.m_responseCombo.isVisible()) {
                        String response = null;
                        response = this.m_responseCombo.getSelectedIndex() >= 0 ? (String)this.m_responseCombo.getSelectedItem() : data.getSelectedResponse();
                        if (response != null) {
                            wob.setSelectedResponse(response);
                        }
                    }
                    wob.doSave(false);
                    wob.doDispatch();
                }
                if (woData == null || woData.getRowIndex() < 0) continue;
                woData.setToBeRemoved(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    private void doUnlock() {
        boolean bDispatch = false;
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_resultsTableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                if (woData.isToBeRemoved() || woData.getLockedStatus() != 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doAbort();
                    wob.doRefresh(false, false);
                    woData.setDirty(false);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                if (woData.isToBeRemoved() || woData.getLockedStatus() != 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doUnlockMany(woArray, false, false);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(false, false);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.setDirty(false);
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private VWWorkObject fetchSpecificWorkObject(VWSession session, String rosterName, String wobNumber) throws Exception {
        VWWorkObject vwWorkObject = null;
        VWRoster vwRoster = null;
        VWRosterQuery vwRosterQuery = null;
        Object[] values = new Object[]{wobNumber};
        int queryFlags = 96;
        try {
            vwRoster = session.getRoster(rosterName);
        }
        catch (VWException e) {
            VWDebug.logException(e);
            throw new Exception(VWResource.s_failedToAccessRoster.toString(rosterName, e.getLocalizedMessage()));
        }
        try {
            vwRosterQuery = vwRoster.createQuery("F_WobNum", values, values, queryFlags, null, null, 1);
            vwWorkObject = (VWWorkObject)vwRosterQuery.next();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            String s = ex.getLocalizedMessage();
            if (s == null) {
                s = "";
            }
            throw new Exception(VWResource.s_failedToRetrieveWorkInRoster.toString(wobNumber, rosterName, s));
        }
        return vwWorkObject;
    }

    private boolean doLockSpecificWorkObject(VWWorkObject wob) throws Exception {
        boolean bOK = true;
        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
        if (woData != null) {
            if (woData.getLockedStatus() != 1) {
                try {
                    wob.doLock(true);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    return bOK;
                }
                catch (Exception ex) {
                    bOK = false;
                    VWDebug.logException(ex);
                    throw ex;
                }
            }
        } else {
            return false;
        }
        return bOK;
    }

    private void doCleanup() {
        this.doUnlock();
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_completeTitle, VWResource.s_completeErr, this.m_vErrors);
            dlg.setVisible(true);
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        this.m_resultsTableModel = null;
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
    }

    private void refreshPanel() {
        try {
            this.m_tableModel.refreshTable();
            this.m_table.tableChanged(null);
            this.m_table.setSize(this.m_scrollPane.getSize());
            this.m_table.sizeColumnsToFit(-1);
            this.resetControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initResponses() {
        if (this.m_responseModel == null) {
            this.m_responseModel = new DefaultComboBoxModel();
        } else {
            this.m_responseModel.removeAllElements();
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private Vector m_columnNames = new Vector();
        private Vector m_rowCache = new Vector();
        private Vector m_wobsList;

        public MyTableModel(Vector wobsList) {
            this.m_wobsList = wobsList;
            this.initColumns();
            this.initRowData();
        }

        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        public int getRowCount() {
            return this.m_rowCache.size();
        }

        public String getColumnName(int col) {
            if (col < this.getColumnCount()) {
                return (String)this.m_columnNames.elementAt(col);
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            DataObject data = (DataObject)this.m_rowCache.elementAt(row);
            Vector rowData = data.getRowData();
            if (rowData != null) {
                return rowData.elementAt(col);
            }
            return null;
        }

        public Object getObjectAt(int row) {
            return (DataObject)this.m_rowCache.elementAt(row);
        }

        public Class getColumnClass(int nColumnIndex) {
            return String.class;
        }

        private void initColumns() {
            this.m_columnNames.addElement(VWResource.s_participantName);
            this.m_columnNames.addElement(VWResource.s_queue);
            this.m_columnNames.addElement(VWResource.s_stepLabel);
            this.m_columnNames.addElement(VWResource.s_subject);
        }

        private void initRowData() {
            try {
                this.m_rowCache.removeAllElements();
                for (int i = 0; i < this.m_wobsList.size(); ++i) {
                    VWWorkObject wob;
                    VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                    if (woData.isToBeRemoved() || (wob = woData.getWob()) == null) continue;
                    this.m_rowCache.addElement(new DataObject(wob));
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshTable() {
            this.initRowData();
        }

        private void removeReferences() {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            if (this.m_wobsList != null) {
                this.m_wobsList.removeAllElements();
                this.m_wobsList = null;
            }
            if (this.m_columnNames != null) {
                this.m_columnNames.removeAllElements();
                this.m_columnNames = null;
            }
        }
    }

    class DataObject {
        private Vector m_rowData = new Vector();
        private String m_currentComments = null;
        private VWWorkObject m_wob = null;
        private String m_selectedResponse = null;
        private String[] m_responses = null;

        public DataObject(VWWorkObject wob) {
            try {
                this.m_wob = wob;
                this.refreshData();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshData() {
            try {
                this.m_wob.doRefresh(true, true);
                this.m_rowData.removeAllElements();
                VWParticipantItem pItem = new VWParticipantItem(this.m_wob.getParticipantNamePx());
                this.m_rowData.addElement(pItem.getDisplayName());
                this.m_rowData.addElement(this.m_wob.getCurrentQueueName());
                this.m_rowData.addElement(this.m_wob.getStepName());
                this.m_rowData.addElement(this.m_wob.getSubject());
                this.m_currentComments = this.m_wob.getComment();
                this.m_selectedResponse = this.m_wob.getSelectedResponse();
                this.m_responses = this.m_wob.getStepResponses();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            }
        }

        private Vector getRowData() {
            return this.m_rowData;
        }

        private VWWorkObject getWob() {
            return this.m_wob;
        }

        private String getCurrentComments() {
            return this.m_currentComments;
        }

        private String getSelectedResponse() {
            return this.m_selectedResponse;
        }

        private String[] getResponses() {
            return this.m_responses;
        }
    }
}

